document.addEventListener('DOMContentLoaded', function() {
    // Social Proof Data with Services
    const socialProofData = [
        { name: "Sarah M.", service: "Deep Cleaning", location: "Minneapolis", time: "12 minutes ago" },
        { name: "Mike R.", service: "Recurring Cleaning", location: "Saint Paul", time: "8 minutes ago" },
        { name: "Jennifer L.", service: "Move-In Cleaning", location: "Bloomington", time: "15 minutes ago" },
        { name: "David W.", service: "Event Cleaning", location: "Plymouth", time: "5 minutes ago" },
        { name: "Lisa T.", service: "Recurring Cleaning", location: "Edina", time: "18 minutes ago" },
        { name: "Robert K.", service: "Deep Cleaning", location: "Minnetonka", time: "22 minutes ago" },
        { name: "Amanda S.", service: "Move-Out Cleaning", location: "Burnsville", time: "11 minutes ago" },
        { name: "Chris P.", service: "Recurring Cleaning", location: "Eagan", time: "7 minutes ago" },
        { name: "Michelle D.", service: "Deep Cleaning", location: "Woodbury", time: "25 minutes ago" },
        { name: "Kevin J.", service: "Event Cleaning", location: "Roseville", time: "14 minutes ago" },
        { name: "Nicole B.", service: "Recurring Cleaning", location: "Maple Grove", time: "9 minutes ago" },
        { name: "Brian H.", service: "Move-In Cleaning", location: "Coon Rapids", time: "19 minutes ago" },
        { name: "Rachel G.", service: "Deep Cleaning", location: "Fridley", time: "13 minutes ago" },
        { name: "Tom A.", service: "Recurring Cleaning", location: "Brooklyn Park", time: "6 minutes ago" },
        { name: "Jessica F.", service: "Event Cleaning", location: "Richfield", time: "21 minutes ago" },
        { name: "Mark C.", service: "Move-Out Cleaning", location: "Hopkins", time: "16 minutes ago" },
        { name: "Stephanie E.", service: "Deep Cleaning", location: "Golden Valley", time: "10 minutes ago" },
        { name: "Andrew N.", service: "Recurring Cleaning", location: "Crystal", time: "23 minutes ago" },
        { name: "Lauren O.", service: "Event Cleaning", location: "New Hope", time: "4 minutes ago" },
        { name: "Daniel Q.", service: "Deep Cleaning", location: "Robbinsdale", time: "17 minutes ago" }
    ];

    let currentIndex = 0;

    // Show Social Proof Popup
    function showSocialProof() {
        const popup = document.getElementById('socialProofPopup');
        const data = socialProofData[currentIndex];
        
        console.log('Showing social proof for:', data);
        
        if (popup && data) {
            // Update popup content
            const customerName = document.getElementById('customerName');
            const serviceType = document.getElementById('serviceType');
            const customerLocation = document.getElementById('customerLocation');
            const bookingTime = document.getElementById('bookingTime');
            
            if (customerName) customerName.textContent = data.name;
            if (serviceType) serviceType.textContent = data.service;
            if (customerLocation) customerLocation.textContent = data.location;
            if (bookingTime) bookingTime.textContent = data.time;
            
            // Show popup with enhanced visibility
            popup.style.display = 'block';
            popup.style.position = 'fixed';
            popup.style.bottom = '20px';
            popup.style.left = '20px';
            popup.style.zIndex = '9999';
            popup.style.opacity = '0';
            popup.style.transform = 'translateX(-100%)';
            
            // Animate in
            setTimeout(() => {
                popup.style.transition = 'all 0.15s ease';
                popup.style.opacity = '1';
                popup.style.transform = 'translateX(0)';
            }, 100);
            
            // Hide after 5 seconds
            setTimeout(() => {
                popup.style.transition = 'all 0.5s ease';
                popup.style.opacity = '0';
                popup.style.transform = 'translateX(-100%)';
                
                setTimeout(() => {
                    popup.style.display = 'none';
                }, 500);
            }, 5000);
            
            // Move to next customer
            currentIndex = (currentIndex + 1) % socialProofData.length;
        } else {
            console.log('Popup element not found or no data');
        }
    }

    // Start showing social proof after 2 seconds, then every 8 seconds for better visibility
    setTimeout(() => {
        console.log('Starting social proof...');
        showSocialProof();
        setInterval(showSocialProof, 30000);
    }, 15000);

    // Initialize Lucide icons
    if (typeof lucide !== 'undefined') {
        lucide.createIcons();
    }
});

